# c6-88 teken- en taalset

Dit document `c6-7` is het hoofddocument van de `c6-88` teken- en taalset.
De  internetthuisbasis van `c6-88` ofwel `c6-6` is [c6-88.org](https://www.c6-88.org).
Daar vind je altijd de laatste officiële documentatie.

## Missie

Tekens en talen beïnvloeden hoe leden in de gemeenschap (kunnen) communiceren, onthouden en denken. 
De missie van `c6-88` is vanuit die kennis ontwikkeld om de gemeenschap nieuwe mogelijkheden te bieden voor het onderhouden en vernieuwen van de gemeenschap zelf.

## Schrijfwijze

`c6-88` wordt ontwikkeld in Nederlands, gebaseerd op het Latijnse schrift en Arabische cijfers.
De documentatie is opgemaakt met [CommonMark Spec](https://spec.commonmark.org/0.30/) om de teksten meer visuele structuur te geven voor de lezer met die technologie, terwijl deze ook goed leesbaar blijft in de eenvoudiger tekstverwerkers.
Alle `c6-88` codes in de documentatie worden tussen twee grafen (\`) geplaatst om duidelijk te maken dat het om `c6-88`-codes gaat. 
Soms wordt in de broncode de combinatie van terugstreep en koppelteken of graaf (\\- of \\\`) gebruikt om een koppelteken (-) of graaf (\`) weer te geven om bepaalde opmaak door CommonMark te voorkomen.

## Hiërarchie

Documenten van `c6-88` bestaan in een stricte hiërarchie.
Ieder document moet geïnterpreteerd worden vanuit documenten hoger in de hiërarchie.
De hiërarchie op het hoogste niveau staat in onderstaande lijst:
1. [`c6-7`](LEESMIJ.md) is de top van de documenthiërarchie van `c6-88` en schept daarmee de context voor al het andere.
2. [`c6-8`](REGELS.md) bevat de regels voor het gebruik en de ontwikkeling van `c6-88`.
3. [`c6-9`](LICENTIE.txt) bevat de licentie rondom de auteursrechten en aanverwante zaken van `c6-88`.
4. [`c6-10`](GEDRAGSCODE.md) bevat de gedragscode voor de gemeenschap die gebruik maakt van `c6-88`.
5. [`c6-11`](BIJDRAGEN.md) bevat de richtlijnen voor deelnemers die willen bijdragen aan de ontwikkeling van `c6-88`.

Alle ontwikkelde producten en diensten die niet onderdeel zijn van deze documentatiehiërarchie dienen te voldoen aan deze documentatiehiërarchie.

## Tekens

Met het woord 'tekens' bedoelen we exclusief de 12 tekens waarmee in `c6-88` gecommuniceerd wordt.
Andere elementen van de taal, zoals onder andere 'code', 'symbolen', 'letters' en 'cijfers', worden gevormd door een combinatie van die tekens.
Om in het Nederlands te kunnen verwijzen naar de tekens, hebben zij elk twee verwijzingen gekregen.
Het onderstaande overzicht bevat op de bovenste rij de `c6-88` tekens.
Daaronder staat hun naam. 
Dit zijn achtereenvolgens de cijfers 1 tot en met 9, het cijfer 0, het koppelteken en de c.
Daaronder is er ook een medeklinker aan elk teken gekoppeld.
In volgorde: s, l, j, h, g, d, v, r, p, w, n en k.
Zo kunnen uitspreekbare woorden gevormd worden door vrije tussenvoeging van klinkers.
In de geschreven documentatie worden alleen de namen gebruikt, niet de medeklinkers.

![De 12 `c6-88` tekens](https://www.c6-88.org/c6-88-namen.png)

## Taalsets

Los betekenen de tekens niets, dat doen zij pas in de context van een taalset.
Er zijn 6 taalsets gedefinieerd.
Elke set heeft een gebruiksdoel:
* [`c1-` set](taalsets/c1-.md): Het alfabet, interpunctie en symbolen voor communicatie van tekst.
* [`c2-` set](taalsets/c2-.md): Cijfers, symbolen en operators voor rekenkundige communicatie in het achttallige stelsel.
* [`c3-` set](taalsets/c3-.md): Concepten om basisboodschappen efficiënter over te kunnen brengen dan met de `c1-` set.
* [`c4-` set](taalsets/c4-.md): Eigennamen die verwijzen naar unieke, levende entiteiten, zoals personen en dieren.
* [`c5-` set](taalsets/c5-.md): Codes om programmering van een microprocessor of -controller over te dragen.
* [`c6-` set](taalsets/c6-.md): Eigennamen die verwijzen naar unieke, niet-levende entiteiten, zoals plaatsen, tijden en voorwerpen.

## Berichten

Elk bericht in `c6-88` begint met het teken `c`.
Het tweede teken is één van de tekens uit {`1`, `2`, `3`, `4`, `5`, `6`} en geeft in combinatie met het eerste teken aan welke taalset gebruikt gaat worden in het bericht.
Het derde teken is de `-`.
Hierna volgen codes, bestaande uit de tekens, in de geselecteerde taalset.
Elk bericht eindigt expliciet met de code `c-` of impliciet door geen tekens meer te noteren of versturen.

Voorbeeldberichten:  
`c3-5-8c-` betekent 'Goed?' (expliciet berichteinde)  
`c3-3` betekent 'Ja' (impliciet berichteinde)

Tijdens een bericht kan er van taalset gewisseld worden.
Dit gebeurt door tijdens een bericht een code te verzenden zoals aan het begin van een bericht.

Voorbeeldbericht:  
`c3-5-c1-5069716978-c3-12-5--11-c1-90797878737114c-` betekent 'Regen daar? Hier zonnig.'


## Status

* Dit is Release v1.3.0 Timmerman.